/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.StackedBarColumnFloorTpModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StackedBarColumnTpModel {
    private List<StackedBarColumnFloorTpModel> floors;
    private long startDate;
    private long endDate;

    public StackedBarColumnTpModel(long startDate, long endDate) {
        Preconditions.checkArgument(GeneralizedRequest.isDateValid(startDate));
        Preconditions.checkArgument(GeneralizedRequest.isDateValid(endDate));
        Preconditions.checkArgument(endDate > startDate);
        this.floors = new ArrayList<StackedBarColumnFloorTpModel>();
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public double getTotalSize() {
        double sum = 0.0;
        for (StackedBarColumnFloorTpModel f : this.floors) {
            Preconditions.checkState((sum += f.getSize()) >= 0.0);
        }
        return sum;
    }

    public String getTotalSizePercentage(double total) {
        if (total <= 0.0) {
            return "N/A";
        }
        return String.format("%.1f%%", this.getTotalSize() / total * 100.0);
    }

    public long getDuration() {
        return this.endDate - this.startDate;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public List<StackedBarColumnFloorTpModel> getFloors() {
        return Collections.unmodifiableList(this.floors);
    }

    public void addFloor(StackedBarColumnFloorTpModel f) {
        Preconditions.checkArgument(f.getSize() >= 0.0);
        Preconditions.checkArgument(!this.floors.contains(f));
        this.floors.add(f);
        this.onFloorAdded(f);
    }

    public void removeFloor(StackedBarColumnFloorTpModel f) {
        Preconditions.checkArgument(this.floors.contains(f));
        this.floors.remove(f);
        this.onFloorRemoved(f);
    }

    public void clearFloors() {
        this.floors.clear();
        this.onFloorsCleared();
    }

    public void mergeFloors(StackedBarColumnTpModel colToMerge) {
        for (StackedBarColumnFloorTpModel f : colToMerge.floors) {
            this.addFloor(f);
        }
    }

    protected void onFloorAdded(StackedBarColumnFloorTpModel f) {
    }

    protected void onFloorRemoved(StackedBarColumnFloorTpModel f) {
    }

    protected void onFloorsCleared() {
    }
}

